<?php
include("db.php"); // Include your database connection

// Set content type to JSON
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the raw POST data
    $rawData = file_get_contents('php://input');

    // Decode the JSON input
    $data = json_decode($rawData, true);

    // Check for JSON decoding errors
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input', 'error_detail' => json_last_error_msg()]);
        exit();
    }

    // Validate required fields
    if (!isset($data['Product_ID']) || !isset($data['Color']) || !isset($data['Size']) || !isset($data['Stock'])) {
        echo json_encode(['status' => 'error', 'message' => 'Required fields are missing']);
        exit();
    }
    $createDate = date('Y-m-d H:i:s'); // Set current date and time
    $deleteStatus = 0; // Default delete status

    // Insert query
    $sql = "INSERT INTO product_variants (Product_ID, variant, Create_Date, Delete_status)
            VALUES ($productId,'$variants','$createDate', $deleteStatus)";

    // Execute the query
    if ($conn->query($sql) === TRUE) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Variant added successfully',
            'data' => [
                'Variant_ID' => $conn->insert_id, // Get the auto-generated ID
            ]
        ]);
    } else {
        // Query execution failed
        echo json_encode(['status' => 'error', 'message' => 'Failed to insert variant', 'error_detail' => $conn->error]);
    }
} else {
    // Handle invalid request method
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

$conn->close();
?>
